/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.common.config.security.service;

import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import java.util.function.Supplier;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.access.intercept.RequestAuthorizationContext;
import org.springframework.stereotype.Service;
import plus.hiver.common.config.security.service.PermissionCheckService;
import plus.hiver.common.config.security.service.TokenValidationService;
import plus.hiver.common.entity.User;
import plus.hiver.common.exception.CustomAuthenticationException;
import plus.hiver.common.utils.BaseContext;
import plus.hiver.common.vo.TokenUser;

@Service
public class CustomAuthorizationManagerServiceImpl
implements AuthorizationManager<RequestAuthorizationContext> {
    @Resource
    private TokenValidationService tokenValidationService;
    @Resource
    private PermissionCheckService permissionCheckService;

    public AuthorizationDecision check(Supplier<Authentication> supplier, RequestAuthorizationContext requestAuthorizationContext) {
        HttpServletRequest httpServletRequest = requestAuthorizationContext.getRequest();
        TokenUser tokenUser = this.tokenValidationService.validateToken(httpServletRequest);
        if (tokenUser == null) {
            return new AuthorizationDecision(false);
        }
        this.validateUserStatus(tokenUser.getUser());
        BaseContext.setUsername(tokenUser.getUsername());
        BaseContext.setUserId(tokenUser.getUserId());
        BaseContext.setUser(tokenUser.getUser());
        Boolean bl = this.permissionCheckService.hasPermission(httpServletRequest);
        return new AuthorizationDecision(bl.booleanValue());
    }

    private void validateUserStatus(User user) {
        if (user == null) {
            throw new CustomAuthenticationException("\u8bf7\u5148\u767b\u9646");
        }
        if (user.getStatus() == -1) {
            throw new CustomAuthenticationException("\u8be5\u8d26\u6237\u5df2\u5c01\u7981");
        }
    }
}

