/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.common.config.security.service;

import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Objects;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.stereotype.Component;
import plus.hiver.common.config.properties.IgnoredUrlsProperties;
import plus.hiver.common.dao.mapper.PermissionMapper;
import plus.hiver.common.dao.mapper.UserRoleMapper;
import plus.hiver.common.entity.Permission;
import plus.hiver.common.entity.Role;
import plus.hiver.common.utils.BaseContext;

@Component
public class PermissionCheckService {
    @Resource
    private UserRoleMapper userRoleMapper;
    @Resource
    private PermissionMapper permissionMapper;
    @Resource
    private IgnoredUrlsProperties ignoredUrlsProperties;

    public Boolean hasPermission(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getMethod();
        Long l = BaseContext.getUserId();
        String string3 = BaseContext.getUsername();
        List<Role> list = this.userRoleMapper.findByUserId(l);
        for (Role object2 : list) {
            if (!object2.getName().contains("ROLE_")) continue;
            return true;
        }
        String string4 = httpServletRequest.getRequestURI();
        for (String string5 : this.ignoredUrlsProperties.getUrls()) {
            if (!string4.contains(string5)) continue;
            return true;
        }
        List<Permission> list2 = this.permissionMapper.findByUserId(l);
        return list2.stream().map(Permission::getPath).filter(Objects::nonNull).anyMatch(string2 -> {
            if (string2.contains("/*") || string2.contains("/**")) {
                return new AntPathRequestMatcher(string2).matches(httpServletRequest);
            }
            return string4.matches((String)string2);
        });
    }
}

