/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.common.sms;

import cn.hutool.core.util.StrUtil;
import jakarta.annotation.Resource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import plus.hiver.common.entity.Setting;
import plus.hiver.common.exception.HiverException;
import plus.hiver.common.service.SettingService;
import plus.hiver.common.sms.SmsFactory;

@Component
public class SmsUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SmsUtil.class);
    @Resource
    private SettingService settingService;
    @Resource
    private SmsFactory smsFactory;

    public String getSmsUsed() {
        Setting setting = this.settingService.findByKey("SMS_USED");
        if (setting == null || StrUtil.isBlank((CharSequence)setting.getValue())) {
            throw new HiverException("\u60a8\u8fd8\u672a\u914d\u7f6e\u77ed\u4fe1\u670d\u52a1");
        }
        String string = setting.getValue();
        return string;
    }

    public String getTemplate(String string) {
        return this.getSmsUsed() + "_" + string;
    }

    public String getTemplateCode(String string) {
        Setting setting = this.settingService.findByKey(this.getTemplate(string));
        if (StrUtil.isBlank((CharSequence)setting.getValue())) {
            throw new HiverException("\u7cfb\u7edf\u8fd8\u672a\u914d\u7f6e\u77ed\u4fe1\u670d\u52a1\u6216\u76f8\u5e94\u77ed\u4fe1\u6a21\u7248");
        }
        return setting.getValue();
    }

    public void sendCode(String string, String string2, String string3) {
        this.sendSms(string, "{code:" + string2 + "}", this.getTemplateCode(string3));
    }

    public void sendSms(String string, String string2, String string3) {
        this.smsFactory.getSms().sendSms(string, string2, string3);
    }
}

