/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.common.utils;

import cn.hutool.core.util.IdUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class Base64DecodeMultipartFile
implements MultipartFile {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Base64DecodeMultipartFile.class);
    private final byte[] imgContent;
    private final String header;

    public Base64DecodeMultipartFile(byte[] byArray, String string) {
        this.imgContent = byArray;
        this.header = string.split(";")[0];
    }

    public String getName() {
        return IdUtil.simpleUUID() + "." + this.header.split("/")[1];
    }

    public String getOriginalFilename() {
        return IdUtil.simpleUUID() + "." + this.header.split("/")[1];
    }

    public String getContentType() {
        return this.header.split(":")[1];
    }

    public boolean isEmpty() {
        return this.imgContent == null || this.imgContent.length == 0;
    }

    public long getSize() {
        return this.imgContent.length;
    }

    public byte[] getBytes() throws IOException {
        return this.imgContent;
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.imgContent);
    }

    public void transferTo(File file) throws IOException, IllegalStateException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            fileOutputStream.write(this.imgContent);
        }
        catch (Exception exception) {
            log.error(exception.toString());
        }
    }

    public static MultipartFile base64Convert(String string) {
        String[] stringArray = string.split(",");
        Base64.Decoder decoder = Base64.getDecoder();
        byte[] byArray = decoder.decode(stringArray[1]);
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] >= 0) continue;
            int n = i;
            byArray[n] = (byte)(byArray[n] + 256);
        }
        return new Base64DecodeMultipartFile(byArray, stringArray[0]);
    }
}

