/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.common.utils;

import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Base64;
import org.bouncycastle.asn1.gm.GMNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.encoders.Hex;

public class SM2Util {
    private static X9ECParameters parameters;
    private static ECDomainParameters domainParameters;
    private static ECParameterSpec ecParameterSpec;

    public static KeyPair generateSm2KeyPair() throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("EC", "BC");
        keyPairGenerator.initialize((AlgorithmParameterSpec)ecParameterSpec, new SecureRandom());
        return keyPairGenerator.generateKeyPair();
    }

    public static String encrypt(String string, String string2) throws Exception {
        ECPoint eCPoint = parameters.getCurve().decodePoint(Hex.decode((String)string));
        ECPublicKeyParameters eCPublicKeyParameters = new ECPublicKeyParameters(eCPoint, domainParameters);
        SM2Engine sM2Engine = new SM2Engine();
        sM2Engine.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)eCPublicKeyParameters, new SecureRandom()));
        byte[] byArray = sM2Engine.processBlock(string2.getBytes(), 0, string2.getBytes().length);
        return Base64.getEncoder().encodeToString(byArray);
    }

    public static String decrypt(String string, String string2) throws Exception {
        BigInteger bigInteger = new BigInteger(string, 16);
        ECPrivateKeyParameters eCPrivateKeyParameters = new ECPrivateKeyParameters(bigInteger, domainParameters);
        SM2Engine sM2Engine = new SM2Engine();
        sM2Engine.init(false, (CipherParameters)eCPrivateKeyParameters);
        byte[] byArray = sM2Engine.processBlock(Base64.getDecoder().decode(string2), 0, Base64.getDecoder().decode(string2).length);
        return new String(byArray);
    }

    public static String getPublicKeyHex(KeyPair keyPair) {
        BCECPublicKey bCECPublicKey = (BCECPublicKey)keyPair.getPublic();
        return Hex.toHexString((byte[])bCECPublicKey.getQ().getEncoded(false));
    }

    public static String getPrivateKeyHex(KeyPair keyPair) {
        BCECPrivateKey bCECPrivateKey = (BCECPrivateKey)keyPair.getPrivate();
        return bCECPrivateKey.getD().toString(16);
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        parameters = GMNamedCurves.getByName((String)"sm2p256v1");
        domainParameters = new ECDomainParameters(parameters.getCurve(), parameters.getG(), parameters.getN(), parameters.getH());
        ecParameterSpec = new ECParameterSpec(parameters.getCurve(), parameters.getG(), parameters.getN(), parameters.getH());
    }
}

