/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.common.service;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import plus.hiver.common.base.HiverBaseService;
import plus.hiver.common.entity.Role;

import java.util.List;

/**
 * 角色接口
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
public interface RoleService extends HiverBaseService<Role, Long> {
    /**
     * 获取默认角色
     */
    List<Role> findByDefaultRole(Boolean defaultRole);

    /**
     * 分页获取
     */
    Page<Role> findByCondition(String key, Pageable pageable);

    /**
     * 获得所有角色
     */
    List<Role> findByDeleted(Integer deleted);
}
