/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.common.base;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;

import java.util.List;

/**
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
public abstract class HiverBaseServiceImpl<T extends HiverBaseEntity, ID extends Long, R extends HiverBaseDao<T, ID>>
        implements HiverBaseService<T, ID> {
    protected final R dao;

    protected HiverBaseServiceImpl(R dao) {
        this.dao = dao;
    }

    @Override
    public T get(ID id) {
        return findById(id);
    }

    @Override
    public T findById(ID id) {
        return dao.findById(id).orElse(null);
    }

    @Override
    public List<T> getAll() {
        return dao.findAll();
    }

    @Override
    public Long getTotalCount() {
        return (long) dao.findAll().size();
    }

    @Override
    public T save(T entity) {
        return dao.save(entity);
    }

    @Override
    public T update(T entity) {
        return dao.saveAndFlush(entity);
    }

    @Override
    public List<T> saveOrUpdateAll(List<T> entities) {
        return dao.saveAll(entities);
    }

    @Override
    public void delete(T entity) {
        dao.delete(entity);
    }

    @Override
    public void delete(ID id) {
        dao.deleteById(id);
    }

    @Override
    public void deleteAllById(List<ID> ids) {
        dao.deleteAllById(ids);
    }

    @Override
    public void delete(List<T> entities) {
        dao.deleteAll(entities);
    }

    @Override
    public void flush() {
        dao.flush();
    }

    @Override
    public List<T> findAll(Specification<T> spec) {
        return dao.findAll();
    }

    @Override
    public Page<T> findAll(Pageable pageable) {
        return dao.findAll(pageable);
    }

    @Override
    public Page<T> findAll(Specification<T> spec, Pageable pageable) {
        return dao.findAll(spec, pageable);
    }

    @Override
    public long count(Specification<T> spec) {
        return dao.findAll(spec).size();
    }
}
