/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.common.config.security.handler;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;
import plus.hiver.common.api.Result;
import plus.hiver.common.exception.CustomAuthenticationException;
import plus.hiver.common.utils.ResponseUtil;
import plus.hiver.common.utils.ResultUtil;

/**
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
@Slf4j
public class SecurityAuthenticationEntryPoint implements AuthenticationEntryPoint {
    @Override
    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) {
        Result<Object> result;
        if (authException instanceof CustomAuthenticationException customException) {
            result = ResultUtil.error(customException.getMessage());
        } else {
            result = ResultUtil.error(401, "无权访问");
        }
        ResponseUtil.out(response, result);
    }
}
