/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.common.config.sm2;

/**
 * SM2服务接口
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
public interface Sm2Service {
    /**
     * 加密数据
     */
    String encrypt(String data);

    /**
     * 解密数据
     */
    String decrypt(String encryptedData);

    /**
     * URL序列化
     *
     * @param encrypted
     * @return
     */
    String encodeForUrl(String encrypted);

    /**
     * URL反序列化
     *
     * @param encoded
     * @return
     */
    String decodeFromUrl(String encoded);

    /**
     * 是否启用SM2
     *
     * @return
     */
    boolean isEnabled();
}
