/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.common.script;

import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import java.util.Map;

/**
 * Groovy 执行脚本
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
public class GroovyScriptEngine {
    private static ScriptEngine SCRIPT_ENGINE;

    public static ScriptEngine getScriptEngine() {
        if (null == SCRIPT_ENGINE) {
            final ScriptEngineManager factory = new ScriptEngineManager();
            SCRIPT_ENGINE = factory.getEngineByName("groovy");
        }
        return SCRIPT_ENGINE;
    }

    public static Object evaluate(String script, Map<String, Object> params) throws ScriptException {
        Bindings bindings = getScriptEngine().createBindings();
        bindings.putAll(params);
        bindings.put("contextParams", params);
        return SCRIPT_ENGINE.eval(script, bindings);
    }
}
