/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.common.serviceimpl;

import lombok.extern.slf4j.Slf4j;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import plus.hiver.common.base.HiverBaseServiceImpl;
import plus.hiver.common.dao.SettingDao;
import plus.hiver.common.entity.Setting;
import plus.hiver.common.service.SettingService;

/**
 * 配置接口实现
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
@Slf4j
@Service
@Transactional
public class SettingServiceImpl extends HiverBaseServiceImpl<Setting, Long, SettingDao> implements SettingService {
    private static final String CACHE_NAMES = "setting";

    public SettingServiceImpl(SettingDao dao) {
        super(dao);
    }

    @Override
    @Cacheable(cacheNames = CACHE_NAMES, key = "#key" , cacheManager = "cacheManagerWithMouth")
    public Setting findByKey(String key) {
        Setting setting = dao.findByKey(key);
        if(setting == null)
        {
            Setting newSetting = new Setting();
            newSetting.setKey(key);
            return newSetting;
        }
        return setting;
    }

    @Override
    @CacheEvict(cacheNames = CACHE_NAMES, key = "#setting.key" , beforeInvocation = true)
    public Setting saveOrUpdate(Setting setting) {
        return dao.saveAndFlush(setting);
    }
}
