/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.common.config.jpa;

import jakarta.annotation.Resource;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreUpdate;
import java.lang.reflect.Field;
import java.util.Date;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import plus.hiver.common.config.jpa.auditor.UserAuditor;
import plus.hiver.common.config.jpa.auditor.UserIdAuditor;
import plus.hiver.common.constant.HiverConstant;

@Configuration
public class CustomAuditHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CustomAuditHandler.class);
    @Resource
    @Qualifier(value="userAuditor")
    private UserAuditor userAuditor;
    @Resource
    @Qualifier(value="userIdAuditor")
    private UserIdAuditor userIdAuditor;

    @PrePersist
    public void prePersist(Object object) {
        try {
            if (this.isCreateOperation()) {
                this.fillFieldIfPresent(object, "createId", this.userIdAuditor.getCurrentAuditor().orElse(null));
                this.fillFieldIfPresent(object, "createBy", this.userAuditor.getCurrentAuditor().orElse(null));
                this.fillFieldIfPresent(object, "createTime", new Date());
                this.fillFieldIfPresent(object, "deleted", HiverConstant.STATUS_NORMAL);
            }
        }
        catch (Exception exception) {
            log.warn("Failed to fill fields during persist: {}", (Object)exception.getMessage());
        }
    }

    @PreUpdate
    public void preUpdate(Object object) {
        try {
            this.fillFieldIfPresent(object, "updateBy", this.userAuditor.getCurrentAuditor().orElse(null));
            this.fillFieldIfPresent(object, "updateTime", new Date());
        }
        catch (Exception exception) {
            log.warn("Failed to fill fields during update: {}", (Object)exception.getMessage());
        }
    }

    private void fillFieldIfPresent(Object object, String string, Object object2) {
        if (object2 == null) {
            return;
        }
        try {
            Field field = this.getField(object.getClass(), string);
            if (field != null) {
                field.setAccessible(true);
                field.set(object, object2);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            log.debug("Field {} not accessible in entity: {}", (Object)string, (Object)object.getClass().getName());
        }
        catch (Exception exception) {
            log.debug("Field {} not present or not writable in entity: {}", (Object)string, (Object)object.getClass().getName());
        }
    }

    private Field getField(Class<?> clazz, String string) {
        try {
            return clazz.getDeclaredField(string);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            Class<?> clazz2 = clazz.getSuperclass();
            if (clazz2 != null && !clazz2.equals(Object.class)) {
                return this.getField(clazz2, string);
            }
            return null;
        }
    }

    private boolean isCreateOperation() {
        try {
            return RequestContextHolder.getRequestAttributes() instanceof ServletRequestAttributes && ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest().getMethod().equalsIgnoreCase("POST");
        }
        catch (Exception exception) {
            log.debug("\u65e0\u6cd5\u786e\u5b9a\u64cd\u4f5c\u7c7b\u578b\uff0c\u9ed8\u8ba4\u975e\u521b\u5efa\u64cd\u4f5c: {}", (Object)exception.getMessage());
            return false;
        }
    }
}

