/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.common.config.jpa.auditor;

import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.domain.AuditorAware;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import plus.hiver.common.vo.TokenUser;

@Configuration
@Primary
public class UserAuditor
implements AuditorAware<String> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserAuditor.class);

    public Optional<String> getCurrentAuditor() {
        try {
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            if (authentication != null && authentication.isAuthenticated() && !(authentication instanceof AnonymousAuthenticationToken)) {
                TokenUser tokenUser = (TokenUser)authentication.getPrincipal();
                String string = "";
                if (tokenUser != null) {
                    string = tokenUser.getUsername();
                    return Optional.of(string);
                }
            }
            return Optional.empty();
        }
        catch (Exception exception) {
            log.warn("Failed to get current user auditor: {}", (Object)exception.getMessage());
            return Optional.empty();
        }
    }
}

