/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.common.config.security.permission;

import cn.hutool.core.util.StrUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.stereotype.Component;
import org.springframework.util.PathMatcher;
import plus.hiver.common.constant.HiverConstant;
import plus.hiver.common.entity.Permission;
import plus.hiver.common.service.PermissionService;

@Component
public class MySecurityMetadataSource
implements FilterInvocationSecurityMetadataSource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MySecurityMetadataSource.class);
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private PathMatcher pathMatcher;
    private Map<String, Collection<ConfigAttribute>> map = null;

    public void loadResourceDefine() {
        this.map = new HashMap<String, Collection<ConfigAttribute>>(16);
        List<Permission> list = this.permissionService.findByTypeAndStatusOrderBySortOrder(HiverConstant.PERMISSION_OPERATION, HiverConstant.STATUS_NORMAL);
        for (Permission permission : list) {
            if (!StrUtil.isNotBlank((CharSequence)permission.getTitle()) || !StrUtil.isNotBlank((CharSequence)permission.getPath())) continue;
            ArrayList<SecurityConfig> arrayList = new ArrayList<SecurityConfig>();
            SecurityConfig securityConfig = new SecurityConfig(permission.getTitle());
            arrayList.add(securityConfig);
            this.map.put(permission.getPath(), arrayList);
        }
    }

    public Collection<ConfigAttribute> getAttributes(Object object) throws IllegalArgumentException {
        if (this.map == null) {
            this.loadResourceDefine();
        }
        String string = ((FilterInvocation)object).getRequestUrl();
        for (String string2 : this.map.keySet()) {
            if (!StrUtil.isNotBlank((CharSequence)string2) || !this.pathMatcher.match(string2, string)) continue;
            return this.map.get(string2);
        }
        return null;
    }

    public Collection<ConfigAttribute> getAllConfigAttributes() {
        return null;
    }

    public boolean supports(Class<?> clazz) {
        return true;
    }
}

