/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.common.sms;

import cn.hutool.core.util.StrUtil;
import com.aliyuncs.CommonRequest;
import com.aliyuncs.CommonResponse;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import jakarta.annotation.Resource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import plus.hiver.common.entity.Setting;
import plus.hiver.common.exception.HiverException;
import plus.hiver.common.service.SettingService;
import plus.hiver.common.sms.Sms;
import plus.hiver.common.vo.SmsSetting;

@Component
public class AliSms
implements Sms {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AliSms.class);
    @Resource
    private SettingService settingService;

    @Override
    public SmsSetting getSmsSetting() {
        Setting setting = this.settingService.findByKey("ALI_SMS");
        if (setting == null || StrUtil.isBlank((CharSequence)setting.getValue())) {
            throw new HiverException("\u60a8\u8fd8\u672a\u914d\u7f6e\u963f\u91cc\u4e91\u77ed\u4fe1\u670d\u52a1");
        }
        return (SmsSetting)new Gson().fromJson(setting.getValue(), SmsSetting.class);
    }

    @Override
    public void sendSms(String string, String string2, String string3) {
        CommonResponse commonResponse;
        SmsSetting smsSetting = this.getSmsSetting();
        DefaultProfile defaultProfile = DefaultProfile.getProfile((String)"cn-hangzhou", (String)smsSetting.getAccessKey(), (String)smsSetting.getSecretKey());
        DefaultAcsClient defaultAcsClient = new DefaultAcsClient((IClientProfile)defaultProfile);
        CommonRequest commonRequest = new CommonRequest();
        commonRequest.setSysMethod(MethodType.POST);
        commonRequest.setSysDomain("dysmsapi.aliyuncs.com");
        commonRequest.setSysVersion("2017-05-25");
        commonRequest.setSysAction("SendSms");
        commonRequest.putQueryParameter("RegionId", "cn-hangzhou");
        commonRequest.putQueryParameter("PhoneNumbers", string);
        commonRequest.putQueryParameter("SignName", smsSetting.getSignName());
        commonRequest.putQueryParameter("TemplateCode", string3);
        commonRequest.putQueryParameter("TemplateParam", string2);
        try {
            commonResponse = defaultAcsClient.getCommonResponse(commonRequest);
        }
        catch (ClientException clientException) {
            log.error(clientException.getMessage());
            throw new HiverException("\u8bf7\u6c42\u53d1\u9001\u77ed\u4fe1\u9a8c\u8bc1\u7801\u5931\u8d25\uff0c" + clientException.getErrMsg());
        }
        JsonObject jsonObject = JsonParser.parseString((String)commonResponse.getData()).getAsJsonObject();
        String string4 = jsonObject.get("Code").getAsString();
        String string5 = jsonObject.get("Message").getAsString();
        if (!"OK".equals(string4) && !"OK".equals(string5)) {
            throw new HiverException("\u8bf7\u6c42\u53d1\u9001\u9a8c\u8bc1\u7801\u5931\u8d25\uff0c" + string5);
        }
    }
}

