/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.common.utils;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import jakarta.servlet.http.HttpServletRequest;
import java.net.InetAddress;
import java.net.UnknownHostException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import plus.hiver.common.utils.AsyncUtil;

@Component
public class IpInfoUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IpInfoUtil.class);
    @Value(value="${hiver.qqlbs.key}")
    private String key;
    @Autowired
    private AsyncUtil asyncUtil;

    public static String getIpAddr(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getHeader("x-forwarded-for");
        if (StrUtil.isBlank((CharSequence)string) || "unknown".equalsIgnoreCase(string)) {
            string = httpServletRequest.getHeader("Proxy-Client-IP");
        }
        if (StrUtil.isBlank((CharSequence)string) || "unknown".equalsIgnoreCase(string)) {
            string = httpServletRequest.getHeader("WL-Proxy-Client-IP");
        }
        if ((StrUtil.isBlank((CharSequence)string) || "unknown".equalsIgnoreCase(string)) && "127.0.0.1".equals(string = httpServletRequest.getRemoteAddr())) {
            InetAddress inetAddress = null;
            try {
                inetAddress = InetAddress.getLocalHost();
                string = inetAddress.getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                log.warn(unknownHostException.toString());
            }
        }
        if (StrUtil.isNotBlank((CharSequence)string) && string.length() > 15 && string.indexOf(",") > 0) {
            string = string.substring(0, string.indexOf(","));
        }
        if ("0:0:0:0:0:0:0:1".equals(string)) {
            string = "127.0.0.1";
        }
        return string;
    }

    public static String getIpCity(String string) {
        Object object = "\u672a\u77e5";
        if (StrUtil.isBlank((CharSequence)string)) {
            return object;
        }
        String string2 = "http://whois.pconline.com.cn/ipJson.jsp?json=true&ip=" + string;
        try {
            String string3 = HttpUtil.get((String)string2, (int)3000);
            JsonObject jsonObject = JsonParser.parseString((String)string3).getAsJsonObject();
            String string4 = jsonObject.get("pro").getAsString();
            String string5 = jsonObject.get("city").getAsString();
            String string6 = jsonObject.get("addr").getAsString();
            if (StrUtil.isNotBlank((CharSequence)string6) && StrUtil.isBlank((CharSequence)string4)) {
                object = string6;
            } else {
                object = string4;
                if (StrUtil.isNotBlank((CharSequence)string5)) {
                    object = (String)object + " " + string5;
                }
            }
        }
        catch (Exception exception) {
            log.info("\u83b7\u53d6IP\u5730\u7406\u4fe1\u606f\u5931\u8d25");
        }
        return object;
    }

    public String getIpCity(HttpServletRequest httpServletRequest) {
        String string = "https://apis.map.qq.com/ws/location/v1/ip?key=" + this.key + "&ip=" + IpInfoUtil.getIpAddr(httpServletRequest);
        Object object = "\u672a\u77e5";
        try {
            String string2 = HttpUtil.get((String)string, (int)3000);
            JsonObject jsonObject = JsonParser.parseString((String)string2).getAsJsonObject();
            String string3 = jsonObject.get("status").getAsString();
            if ("0".equals(string3)) {
                JsonObject jsonObject2 = jsonObject.get("result").getAsJsonObject().get("ad_info").getAsJsonObject();
                String string4 = jsonObject2.get("nation").getAsString();
                String string5 = jsonObject2.get("province").getAsString();
                String string6 = jsonObject2.get("city").getAsString();
                String string7 = jsonObject2.get("district").getAsString();
                if (StrUtil.isNotBlank((CharSequence)string4) && StrUtil.isBlank((CharSequence)string5)) {
                    object = string4;
                } else {
                    object = string5;
                    if (StrUtil.isNotBlank((CharSequence)string6)) {
                        object = (String)object + " " + string6;
                    }
                    if (StrUtil.isNotBlank((CharSequence)string7)) {
                        object = (String)object + " " + string7;
                    }
                }
            }
        }
        catch (Exception exception) {
            log.info("\u83b7\u53d6IP\u5730\u7406\u4fe1\u606f\u5931\u8d25");
        }
        return object;
    }

    public void getInfo(HttpServletRequest httpServletRequest, String string) {
        try {
            String string2 = httpServletRequest.getRequestURL().toString();
            this.asyncUtil.getInfo(string2, string);
        }
        catch (Exception exception) {
            log.warn(exception.toString());
        }
    }
}

