/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.common.api;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import jakarta.validation.constraints.Positive;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 分页查询参数
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
@Getter
@Setter
public class PageParam<T> implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 请求数据的页码
     */
    @Positive
    private Long page;

    /**
     * 每页条数
     */
    @Positive
    private Long pageSize;

    /**
     * 查询实体对象
     */
    private T data;

    public <T> Page<T> page() {
        return page(20L);
    }

    public <T> Page<T> page(long size) {
        if (null == this.pageSize || this.pageSize < 1L) {
            this.pageSize = size;
        }
        if (null == this.page) {
            this.page = 1L;
        }
        return new Page(this.page, this.pageSize);
    }
}
