/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.common.config.web;

import jakarta.annotation.Resource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.servlet.config.annotation.PathMatchConfigurer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
/**
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
@Configuration
public class WebConfig implements WebMvcConfigurer {
    @Resource
    private RedisTemplate<String, Object> redisTemplate;

    @Override
    public void configurePathMatch(PathMatchConfigurer configurer) {
        configurer
                .setUseTrailingSlashMatch(false) // 禁用尾部斜杠自动匹配
                .setPathMatcher(new SmartPathMatcher()) // 自定义路径匹配器
                .setUrlPathHelper(new SmartUrlPathHelper()) // 自定义URL解析器
                .setPatternParser(null); // 启用AntPathMatcher
    }

    @Bean
    public RedisTemplate<String, Object> restTemplate() {
        return redisTemplate;
    }
}
