/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.common.constant;

/**
 * 配置常量
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
public interface SettingConstant {
    /**
     * 当前使用OSS
     */
    String OSS_USED = "OSS_USED";

    /**
     * 阿里OSS配置
     */
    String RUSTFS_OSS = "RUSTFS_OSS";

    /**
     * 本地OSS配置
     */
    String LOCAL_OSS = "LOCAL_OSS";

    /**
     * OSS配置类型
     */
    enum OSS_TYPE {
        // 本地OSS配置
        LOCAL_OSS,
        // Rustfs OSS配置
        RUSTFS_OSS;

        public static Boolean isContainName(String type) {
            for (OSS_TYPE item : OSS_TYPE.values()) {
                if (item.name().equals(type)) {
                    return true;
                }
            }
            return false;
        }

        public static Integer getOrdinal(String type) {
            for (OSS_TYPE item : OSS_TYPE.values()) {
                if (item.name().equals(type)) {
                    return item.ordinal();
                }
            }
            return -1;
        }

        public static String getName(Integer type) {
            if (type == null) {
                return "";
            }
            for (OSS_TYPE item : OSS_TYPE.values()) {
                if (type.equals(item.ordinal())) {
                    return item.name();
                }
            }
            return "";
        }
    }

    /**
     * 当前使用短信
     */
    String SMS_USED = "SMS_USED";

    /**
     * 阿里短信配置
     */
    String ALI_SMS = "ALI_SMS";

    /**
     * 短信模版类型
     */
    enum SMS_TYPE {
        // 通用
        SMS_COMMON("通用验证码"),
        // 登录验证码
        SMS_LOGIN("登录验证码"),
        // 注册验证码
        SMS_REGISTER("注册验证码"),
        // 修改绑定手机号
        SMS_CHANGE_MOBILE("修改绑定手机号"),
        // 修改密码
        SMS_CHANGE_PASS("修改密码"),
        // 重置密码
        SMS_RESET_PASS("重置密码"),
        // 工作流消息
        SMS_ACTIVITI("工作流消息");

        private final String title;

        SMS_TYPE(String title) {
            this.title = title;
        }

        public String getTitle() {
            return title;
        }
    }

    /**
     * 邮箱配置
     */
    String EMAIL_SETTING = "EMAIL_SETTING";

    /**
     * 公告配置
     */
    String NOTICE_SETTING = "NOTICE_SETTING";

    /**
     * 其他配置
     */
    String OTHER_SETTING = "OTHER_SETTING";
}
