/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.common.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import plus.hiver.common.base.HiverBaseEntity;
import plus.hiver.common.utils.ObjectUtil;

import java.util.Map;

/**
 * 日志实体类
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
@Data
@Entity
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Table(name = "t_log")
@TableName("t_log")
@Tag(name = "日志")
public class Log extends HiverBaseEntity {
    private static final long serialVersionUID = 1L;

    @Schema(description = "方法操作名称")
    private String name;

    @Schema(description = "日志类型 0登陆日志 1操作日志")
    private Integer logType;

    @Schema(description = "请求路径")
    private String requestUrl;

    @Schema(description = "请求类型")
    private String requestType;

    @Schema(description = "请求参数")
    private String requestParam;

    @Schema(description = "请求用户")
    private String username;

    @Schema(description = "ip")
    private String ip;

    @Schema(description = "ip信息")
    private String ipInfo;

    @Schema(description = "设备信息")
    private String device;

    @Schema(description = "花费时间")
    private Integer costTime;

    /**
     * 转换请求参数为Json
     *
     * @param paramMap
     */
    public void setMapToParams(Map<String, String[]> paramMap) {
        this.requestParam = ObjectUtil.mapToString(paramMap);
    }
}
