/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.common.service;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import plus.hiver.common.base.HiverBaseService;
import plus.hiver.common.entity.Tenant;
import plus.hiver.common.vo.SearchVo;

import java.util.List;

/**
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
public interface TenantService extends HiverBaseService<Tenant, Long> {
    Tenant findByName(String name);

    List<Tenant> findByStatusAndDeleted(Integer status, Integer deleted);

    Page<Tenant> findByCondition(Tenant tenant, SearchVo searchVo, Pageable pageable);
}
