/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.common.service.mybatis;

import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.Cacheable;
import plus.hiver.common.config.mybatisplus.service.IBaseService;
import plus.hiver.common.entity.Role;
import plus.hiver.common.entity.UserRole;

import java.util.List;

/**
 * 用户角色接口
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
@CacheConfig(cacheNames = "userRole")
public interface IUserRoleService extends IBaseService<UserRole> {
    /**
     * 通过用户id获取
     */
    @Cacheable(key = "#userId")
    List<Role> findByUserId(Long userId);

    /**
     * 通过用户id获取用户角色关联的部门数据
     */
    List<Long> findDepIdsByUserId(Long userId);

    /**
     * 通过角色ID列表获得用户列表
     */
    List<Long> listbyRoleIds(List<Long> roleIds);
}
