/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.common.utils;

import cn.hutool.core.util.IdUtil;
import cn.hutool.http.useragent.UserAgent;
import cn.hutool.http.useragent.UserAgentUtil;
import jakarta.servlet.http.HttpServletRequest;

/**
 * 常用工具
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
public class CommonUtil {
    private CommonUtil() {
        throw new IllegalStateException("Utility class");
    }

    /**
     * 批量递归删除时 判断target是否在ids中 避免重复删除
     *
     * @param target 目标id
     * @param ids    待删除id数组
     * @return 是否存在
     */
    public static Boolean judgeIds(Long target, Long[] ids) {
        Boolean flag = false;
        for (Long id : ids) {
            if (id.equals(target)) {
                flag = true;
                break;
            }
        }
        return flag;
    }

    /**
     * 获取请求设备信息
     *
     * @return 设备信息
     */
    public static String getDeviceInfo(HttpServletRequest request) {
        UserAgent ua = UserAgentUtil.parse(request.getHeader("user-agent"));
        if (ua == null) {
            return "";
        }
        String isMobile = ua.isMobile() ? "移动端" : "PC端";
        String device = ua.getBrowser().toString() + " " + ua.getVersion() + " | " + ua.getPlatform().toString()
                + " " + ua.getOs().toString() + " | " + isMobile;
        return device;
    }

    /**
     * 以UUID重命名
     *
     * @param fileName 原文件名
     * @return 新文件名
     */
    public static String renamePic(String fileName) {
        String extName = "";
        if (fileName.contains(".")) {
            extName = fileName.substring(fileName.lastIndexOf("."));
        }
        return IdUtil.simpleUUID() + extName;
    }
}
