/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.common.aop;

import com.google.gson.Gson;
import jakarta.annotation.Resource;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import lombok.Generated;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.stereotype.Component;
import plus.hiver.common.annotation.Encrypt;
import plus.hiver.common.api.Result;
import plus.hiver.common.config.sm2.Sm2Service;
import plus.hiver.common.utils.ResultUtil;

@Aspect
@Component
public class EncryptAspect {
    @Resource
    private Sm2Service sm2Service;
    private final Gson gson = new Gson();

    @Around(value="@annotation(encrypt)")
    public Object around(ProceedingJoinPoint proceedingJoinPoint, Encrypt encrypt) throws Throwable {
        if (!this.sm2Service.isEnabled()) {
            return proceedingJoinPoint.proceed();
        }
        Object object = proceedingJoinPoint.proceed();
        if (object instanceof Result) {
            Result result = (Result)object;
            return this.processGenericResult(result);
        }
        return this.sm2Service.encodeForUrl(this.sm2Service.encrypt(object.toString()));
    }

    private <T> Result<String> processGenericResult(Result<T> result) {
        try {
            Type type = this.getGenericType(result);
            Object object = result.getResult();
            if (object instanceof String) {
                String string = (String)object;
                object = this.sm2Service.encrypt(string);
                return ResultUtil.data(this.base64Encoder(this.sm2Service.encodeForUrl((String)object)));
            }
            if (result.getResult() != null) {
                String string = this.gson.toJson(result.getResult(), type);
                object = this.sm2Service.encrypt(string);
                return ResultUtil.data(this.base64Encoder(this.sm2Service.encodeForUrl((String)object)));
            }
            return ResultUtil.data(null);
        }
        catch (Exception exception) {
            throw new RuntimeException("\u7ed3\u679c\u52a0\u5bc6\u5931\u8d25", exception);
        }
    }

    private <T> Type getGenericType(Result<T> result) {
        try {
            return result.getClass().getMethod("getResult", new Class[0]).getGenericReturnType();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return Object.class;
        }
    }

    private String base64Encoder(String string) {
        return Base64.getUrlEncoder().withoutPadding().encodeToString(string.getBytes(StandardCharsets.UTF_8));
    }

    @Generated
    public EncryptAspect() {
    }
}

