/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.common.config.mybatisplus;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.BlockAttackInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.OptimisticLockerInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import plus.hiver.common.config.mybatisplus.JsonAutoConfiguration;
import plus.hiver.common.config.mybatisplus.MyMetaObjectHandler;
import plus.hiver.common.config.mybatisplus.mapper.HiverSqlInjector;

@EnableTransactionManagement
@Configuration
@Import(value={JsonAutoConfiguration.class})
public class MybatisPlusConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MybatisPlusConfig.class);

    @Bean
    @ConditionalOnMissingBean
    public MybatisPlusInterceptor mybatisPlusInterceptor() {
        MybatisPlusInterceptor mybatisPlusInterceptor = new MybatisPlusInterceptor();
        PaginationInnerInterceptor paginationInnerInterceptor = new PaginationInnerInterceptor(DbType.MYSQL);
        paginationInnerInterceptor.setMaxLimit(Long.valueOf(400L));
        mybatisPlusInterceptor.addInnerInterceptor((InnerInterceptor)paginationInnerInterceptor);
        mybatisPlusInterceptor.addInnerInterceptor((InnerInterceptor)new OptimisticLockerInnerInterceptor());
        mybatisPlusInterceptor.addInnerInterceptor((InnerInterceptor)new BlockAttackInnerInterceptor());
        return mybatisPlusInterceptor;
    }

    @Bean
    @ConditionalOnMissingBean
    public HiverSqlInjector batchSqlInjector() {
        return new HiverSqlInjector();
    }

    @Bean
    @ConditionalOnMissingBean
    public MyMetaObjectHandler metaObjectHandler() {
        return new MyMetaObjectHandler();
    }
}

