/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.common.serviceimpl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import plus.hiver.common.base.HiverBaseServiceImpl;
import plus.hiver.common.dao.TenantDao;
import plus.hiver.common.entity.Tenant;
import plus.hiver.common.service.TenantService;
import plus.hiver.common.vo.SearchVo;

@Service
@Transactional
public class TenantServiceImpl
extends HiverBaseServiceImpl<Tenant, Long, TenantDao>
implements TenantService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantServiceImpl.class);

    protected TenantServiceImpl(TenantDao tenantDao) {
        super(tenantDao);
    }

    @Override
    public Tenant findByName(String string) {
        return ((TenantDao)this.dao).findByName(string);
    }

    @Override
    public List<Tenant> findByStatusAndDeleted(Integer n, Integer n2) {
        return ((TenantDao)this.dao).findByStatusAndDeleted(n, n2);
    }

    @Override
    public Page<Tenant> findByCondition(final Tenant tenant, final SearchVo searchVo, Pageable pageable) {
        return ((TenantDao)this.dao).findAll((Specification)new Specification<Tenant>(){

            @Nullable
            public Predicate toPredicate(Root<Tenant> root, CriteriaQuery<?> criteriaQuery, CriteriaBuilder criteriaBuilder) {
                Predicate[] predicateArray;
                Path path = root.get("name");
                Path path2 = root.get("domain");
                Path path3 = root.get("username");
                Path path4 = root.get("mobile");
                Path path5 = root.get("status");
                Path path6 = root.get("createTime");
                ArrayList<Predicate> arrayList = new ArrayList<Predicate>();
                if (StrUtil.isNotBlank((CharSequence)tenant.getName())) {
                    arrayList.add(criteriaBuilder.like((Expression)path, "%" + tenant.getName() + "%"));
                }
                if (StrUtil.isNotBlank((CharSequence)tenant.getDomain())) {
                    arrayList.add(criteriaBuilder.like((Expression)path2, "%" + tenant.getDomain() + "%"));
                }
                if (StrUtil.isNotBlank((CharSequence)tenant.getUsername())) {
                    arrayList.add(criteriaBuilder.like((Expression)path3, "%" + tenant.getUsername() + "%"));
                }
                if (StrUtil.isNotBlank((CharSequence)tenant.getMobile())) {
                    arrayList.add(criteriaBuilder.like((Expression)path4, "%" + tenant.getMobile() + "%"));
                }
                if (tenant.getStatus() != null) {
                    arrayList.add(criteriaBuilder.equal((Expression)path5, (Object)tenant.getStatus()));
                }
                if (StrUtil.isNotBlank((CharSequence)searchVo.getStartDate()) && StrUtil.isNotBlank((CharSequence)searchVo.getEndDate())) {
                    predicateArray = DateUtil.parse((CharSequence)searchVo.getStartDate());
                    DateTime dateTime = DateUtil.parse((CharSequence)searchVo.getEndDate());
                    arrayList.add(criteriaBuilder.between((Expression)path6, (Comparable)predicateArray, (Comparable)DateUtil.endOfDay((Date)dateTime)));
                }
                arrayList.add(criteriaBuilder.equal((Expression)path5, (Object)0));
                predicateArray = new Predicate[arrayList.size()];
                criteriaQuery.where(arrayList.toArray(predicateArray));
                return null;
            }
        }, pageable);
    }
}

