/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.common.utils;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.ArrayList;
import java.util.List;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import plus.hiver.common.exception.HiverException;
import plus.hiver.common.vo.PageVo;

public class PageUtil {
    private static final String[] KEYWORDS = new String[]{"master", "truncate", "insert", "select", "delete", "update", "declare", "alter", "drop", "sleep"};

    private PageUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static Pageable initPage(PageVo pageVo) {
        PageRequest pageRequest = null;
        int n = pageVo.getPageNumber();
        int n2 = pageVo.getPageSize();
        String string = pageVo.getSort();
        String string2 = pageVo.getOrder();
        if (n < 1) {
            n = 1;
        }
        if (n2 < 1) {
            n2 = 10;
        }
        if (n2 > 100) {
            n2 = 100;
        }
        if (StrUtil.isNotBlank((CharSequence)string)) {
            Sort.Direction direction = StrUtil.isBlank((CharSequence)string2) ? Sort.Direction.DESC : Sort.Direction.valueOf((String)string2.toUpperCase());
            Sort sort = Sort.by((Sort.Direction)direction, (String[])new String[]{string});
            pageRequest = PageRequest.of((int)(n - 1), (int)n2, (Sort)sort);
        } else {
            pageRequest = PageRequest.of((int)(n - 1), (int)n2);
        }
        return pageRequest;
    }

    public static Page initMpPage(PageVo pageVo) {
        Page page = null;
        int n = pageVo.getPageNumber();
        int n2 = pageVo.getPageSize();
        String string = pageVo.getSort();
        String string2 = pageVo.getOrder();
        PageUtil.SQLInject(string);
        if (n < 1) {
            n = 1;
        }
        if (n2 < 1) {
            n2 = 10;
        }
        if (n2 > 100) {
            n2 = 100;
        }
        if (StrUtil.isNotBlank((CharSequence)string)) {
            Boolean bl = false;
            if (StrUtil.isBlank((CharSequence)string2)) {
                bl = false;
            } else if ("desc".equals(string2.toLowerCase())) {
                bl = false;
            } else if ("asc".equals(string2.toLowerCase())) {
                bl = true;
            }
            page = new Page((long)n, (long)n2);
            if (bl.booleanValue()) {
                page.addOrder(new OrderItem[]{OrderItem.asc((String)PageUtil.camel2Underline(string))});
            } else {
                page.addOrder(new OrderItem[]{OrderItem.desc((String)PageUtil.camel2Underline(string))});
            }
        } else {
            page = new Page((long)n, (long)n2);
        }
        return page;
    }

    public static List listToPage(PageVo pageVo, List list) {
        int n = pageVo.getPageNumber() - 1;
        int n2 = pageVo.getPageSize();
        if (n < 0) {
            n = 0;
        }
        if (n2 < 1) {
            n2 = 10;
        }
        if (n2 > 100) {
            n2 = 100;
        }
        int n3 = n * n2;
        int n4 = n * n2 + n2;
        if (n3 > list.size()) {
            return new ArrayList();
        }
        if (n4 >= list.size()) {
            return list.subList(n3, list.size());
        }
        return list.subList(n3, n4);
    }

    public static String camel2Underline(String string) {
        if (StrUtil.isBlank((CharSequence)string)) {
            return "";
        }
        if (string.length() == 1) {
            return string.toLowerCase();
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 1; i < string.length(); ++i) {
            if (Character.isUpperCase(string.charAt(i))) {
                stringBuilder.append("_" + Character.toLowerCase(string.charAt(i)));
                continue;
            }
            stringBuilder.append(string.charAt(i));
        }
        return (string.charAt(0) + stringBuilder.toString()).toLowerCase();
    }

    public static void SQLInject(String string) {
        if (StrUtil.isBlank((CharSequence)string)) {
            return;
        }
        string = string.toLowerCase();
        for (String string2 : KEYWORDS) {
            if (!string.contains(string2)) continue;
            throw new HiverException(string + "\u5305\u542b\u975e\u6cd5\u5b57\u7b26");
        }
    }
}

