/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.common.utils;

import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Component;
import plus.hiver.common.config.properties.HiverTokenProperties;
import plus.hiver.common.constant.HiverConstant;
import plus.hiver.common.constant.UserConstant;
import plus.hiver.common.dao.DepartmentDao;
import plus.hiver.common.dao.UserDao;
import plus.hiver.common.dao.mapper.PermissionMapper;
import plus.hiver.common.dao.mapper.UserRoleMapper;
import plus.hiver.common.dto.PermissionDTO;
import plus.hiver.common.dto.RoleDTO;
import plus.hiver.common.entity.Department;
import plus.hiver.common.entity.Permission;
import plus.hiver.common.entity.Role;
import plus.hiver.common.entity.User;
import plus.hiver.common.exception.HiverException;
import plus.hiver.common.redis.RedisTemplateHelper;
import plus.hiver.common.service.mybatis.IUserRoleService;
import plus.hiver.common.utils.JwtTokenUtil;
import plus.hiver.common.utils.NameUtil;
import plus.hiver.common.vo.OnlineUserVo;
import plus.hiver.common.vo.TokenUser;

@Component
public class SecurityUtil {
    @Resource
    private HiverTokenProperties tokenProperties;
    @Resource
    private UserDao userDao;
    @Resource
    private IUserRoleService iUserRoleService;
    @Resource
    private UserRoleMapper userRoleMapper;
    @Resource
    private PermissionMapper permissionMapper;
    @Resource
    private DepartmentDao departmentDao;
    @Resource
    private HttpServletRequest request;
    @Resource
    private RedisTemplateHelper redisTemplateHelper;

    public List<Long> getDeparmentIds() {
        ArrayList<Long> arrayList = new ArrayList();
        User user = this.getCurrUser();
        String string = "userRole::depIds:" + user.getId();
        String string2 = this.redisTemplateHelper.get(string);
        if (StrUtil.isNotBlank((CharSequence)string2)) {
            arrayList = (List)new Gson().fromJson(string2, new TypeToken<List<String>>(){}.getType());
            return arrayList;
        }
        List<Role> list = this.iUserRoleService.findByUserId(user.getId());
        Boolean bl = false;
        for (Role role : list) {
            if (role.getDataType() != null && !role.getDataType().equals(HiverConstant.DATA_TYPE_ALL)) continue;
            bl = true;
            break;
        }
        if (bl.booleanValue()) {
            return null;
        }
        for (Role role : list) {
            List<Long> list2;
            if (role.getDataType().equals(HiverConstant.DATA_TYPE_UNDER)) {
                if (user.getDepartmentId() == 0L) {
                    arrayList.add(-1L);
                    continue;
                }
                list2 = new ArrayList<Long>();
                this.getDepRecursion(user.getDepartmentId(), list2);
                arrayList.addAll(list2);
                continue;
            }
            if (role.getDataType().equals(HiverConstant.DATA_TYPE_SAME)) {
                if (user.getDepartmentId() == 0L) {
                    arrayList.add(-1L);
                    continue;
                }
                arrayList.add(user.getDepartmentId());
                continue;
            }
            if (role.getDataType().equals(HiverConstant.DATA_TYPE_CUSTOM)) {
                list2 = this.iUserRoleService.findDepIdsByUserId(user.getId());
                if (list2 == null || list2.size() == 0) {
                    arrayList.add(-1L);
                    continue;
                }
                arrayList.addAll(list2);
                continue;
            }
            if (!role.getDataType().equals(HiverConstant.DATA_TYPE_SELF)) continue;
            arrayList.add(-2L);
        }
        LinkedHashSet linkedHashSet = new LinkedHashSet(arrayList.size());
        linkedHashSet.addAll(arrayList);
        arrayList.clear();
        arrayList.addAll(linkedHashSet);
        this.redisTemplateHelper.set(string, new Gson().toJson(arrayList), 15L, TimeUnit.DAYS);
        return arrayList;
    }

    public User getCurrUserSimple() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null || !authentication.isAuthenticated() || authentication.getName() == null || authentication instanceof AnonymousAuthenticationToken) {
            throw new HiverException("\u672a\u68c0\u6d4b\u5230\u767b\u5f55\u7528\u6237");
        }
        TokenUser tokenUser = (TokenUser)authentication.getPrincipal();
        User user = new User().setAppId(tokenUser.getAppId()).setUsername(tokenUser.getUsername()).setNickname(tokenUser.getNickname()).setMobile(tokenUser.getMobile()).setEmail(tokenUser.getEmail()).setDepartmentId(tokenUser.getDepartmentId()).setType(tokenUser.getType());
        if (tokenUser.getPermissions() != null && !tokenUser.getPermissions().isEmpty()) {
            user.setPermissions(tokenUser.getPermissions().stream().map(permissionDTO -> new PermissionDTO().setTitle(permissionDTO.getTitle())).collect(Collectors.toList()));
        }
        user.setId(tokenUser.getUserId());
        return user;
    }

    public List<GrantedAuthority> getCurrUserPerms(String string) {
        ArrayList<GrantedAuthority> arrayList = new ArrayList<GrantedAuthority>();
        User user = this.findUserByUsername(string);
        if (user == null || user.getPermissions() == null || user.getPermissions().isEmpty()) {
            return arrayList;
        }
        for (PermissionDTO permissionDTO : user.getPermissions()) {
            arrayList.add((GrantedAuthority)new SimpleGrantedAuthority(permissionDTO.getTitle()));
        }
        return arrayList;
    }

    public User getCurrUser() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null || !authentication.isAuthenticated() || authentication.getName() == null || authentication instanceof AnonymousAuthenticationToken) {
            throw new HiverException("\u672a\u68c0\u6d4b\u5230\u767b\u5f55\u7528\u6237");
        }
        TokenUser tokenUser = (TokenUser)authentication.getPrincipal();
        return tokenUser.getUser();
    }

    public User findUserByUsername(String string) {
        String string2 = "username::" + string;
        String string3 = this.redisTemplateHelper.get(string2);
        if (StrUtil.isNotBlank((CharSequence)string3)) {
            return this.userToDTO((User)new Gson().fromJson(string3, User.class));
        }
        User user = this.userToDTO(this.userDao.findByUsername(string));
        this.redisTemplateHelper.set(string2, new Gson().toJson((Object)user), 15L, TimeUnit.DAYS);
        return user;
    }

    public User userToDTO(User user) {
        if (user == null) {
            return null;
        }
        List<Role> list = this.userRoleMapper.findByUserId(user.getId());
        List<RoleDTO> list2 = list.stream().map(role -> new RoleDTO().setId(role.getId()).setName(role.getName())).collect(Collectors.toList());
        user.setRoles(list2);
        List<Permission> list3 = this.permissionMapper.findByUserId(user.getId());
        List<PermissionDTO> list4 = list3.stream().filter(permission -> HiverConstant.PERMISSION_OPERATION.equals(permission.getType())).map(permission -> new PermissionDTO().setTitle(permission.getTitle()).setPath(permission.getPath())).collect(Collectors.toList());
        user.setPermissions(list4);
        return user;
    }

    private void getDepRecursion(Long l, List<Long> list) {
        Department department2 = (Department)this.departmentDao.getReferenceById(l);
        list.add(department2.getId());
        if (department2.getIsParent() != null && department2.getIsParent().booleanValue()) {
            List<Department> list2 = this.departmentDao.findByParentIdAndStatusOrderBySortOrder(l, HiverConstant.STATUS_NORMAL);
            list2.forEach(department -> this.getDepRecursion(department.getId(), list));
        }
    }

    public User checkUserPassword(String string, String string2) {
        User user = NameUtil.mobile(string) ? this.findUserByMobile(string) : (NameUtil.email(string) ? this.findUserByEmail(string) : this.findUserByUsername(string));
        if (user == null) {
            return null;
        }
        Boolean bl = new BCryptPasswordEncoder().matches((CharSequence)string2, user.getPassword());
        if (!bl.booleanValue()) {
            return null;
        }
        return user;
    }

    public User findUserByMobile(String string) {
        return this.userToDTO(this.userDao.findByMobile(string));
    }

    public User findUserByEmail(String string) {
        return this.userToDTO(this.userDao.findByEmail(string));
    }

    public String getToken(String string, Boolean bl) {
        if (StrUtil.isBlank((CharSequence)string)) {
            throw new HiverException("username\u4e0d\u80fd\u4e3a\u7a7a");
        }
        User user = this.findUserByUsername(string);
        return this.getToken(user, bl);
    }

    public String getToken(User user, Boolean bl) {
        String string;
        TokenUser tokenUser;
        String string2;
        if (user == null) {
            throw new HiverException("user\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (UserConstant.USER_STATUS_LOCK.equals(user.getStatus())) {
            throw new HiverException("\u8d26\u6237\u88ab\u7981\u7528\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        Boolean bl2 = false;
        if (bl == null || bl.booleanValue()) {
            bl2 = true;
            if (!this.tokenProperties.getRedis().booleanValue()) {
                this.tokenProperties.setTokenExpireTime(this.tokenProperties.getSaveLoginTime() * 60 * 24);
            }
        }
        if (this.tokenProperties.getRedis().booleanValue()) {
            string2 = IdUtil.simpleUUID();
            tokenUser = new TokenUser(user, this.tokenProperties.getStorePerms(), bl2);
            tokenUser.setUser(user);
            tokenUser.setToken(string2);
            tokenUser.setSaveLogin(bl2);
            if (this.tokenProperties.getSdl().booleanValue() && StrUtil.isNotBlank((CharSequence)(string = this.redisTemplateHelper.get("HIVER_USER_TOKEN:" + user.getUsername())))) {
                this.redisTemplateHelper.delete("HIVER_TOKEN_PRE:" + string);
            }
            if (bl2.booleanValue()) {
                this.redisTemplateHelper.set("HIVER_USER_TOKEN:" + user.getUsername(), string2, this.tokenProperties.getSaveLoginTime().intValue(), TimeUnit.DAYS);
                this.redisTemplateHelper.set("HIVER_TOKEN_PRE:" + string2, new Gson().toJson((Object)tokenUser), this.tokenProperties.getSaveLoginTime().intValue(), TimeUnit.DAYS);
            } else {
                this.redisTemplateHelper.set("HIVER_USER_TOKEN:" + user.getUsername(), string2, this.tokenProperties.getTokenExpireTime().intValue(), TimeUnit.MINUTES);
                this.redisTemplateHelper.set("HIVER_TOKEN_PRE:" + string2, new Gson().toJson((Object)tokenUser), this.tokenProperties.getTokenExpireTime().intValue(), TimeUnit.MINUTES);
            }
            OnlineUserVo.update(string2, user.getUsername(), false, this.redisTemplateHelper, this.request);
        } else {
            tokenUser = new TokenUser(user, false, null);
            string2 = JwtTokenUtil.createToken(tokenUser.getUserId(), tokenUser.getUsername(), this.tokenProperties.getSaveLoginTime());
            tokenUser.setUser(user);
            tokenUser.setToken(string2);
            tokenUser.setSaveLogin(bl2);
            this.redisTemplateHelper.set("HIVER_TOKEN_PRE:" + string2, new Gson().toJson((Object)tokenUser), this.tokenProperties.getSaveLoginTime().intValue(), TimeUnit.DAYS);
            OnlineUserVo.update(string2, user.getUsername(), true, this.redisTemplateHelper, this.request);
        }
        string = new UsernamePasswordAuthenticationToken((Object)tokenUser, null, null);
        SecurityContextHolder.getContext().setAuthentication((Authentication)string);
        return string2;
    }
}

