/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.common.config.jpa.auditor;

import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.domain.AuditorAware;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import plus.hiver.common.vo.TokenUser;

import java.util.Optional;

/**
 * 用户审计器 - 处理createBy字段
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
@Configuration
@Slf4j
@Primary
public class UserAuditor implements AuditorAware<String> {
    @Override
    public Optional<String> getCurrentAuditor() {
        try {
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            if (authentication != null
                    && authentication.isAuthenticated()
                    && !(authentication instanceof AnonymousAuthenticationToken)) {
                TokenUser tokenUser = (TokenUser) authentication.getPrincipal();
                String username = "";
                if(tokenUser != null) {
                    username = tokenUser.getUsername();
                    // 只返回用户名，用于createBy字段
                    return Optional.of(username);
                }
            }
            return Optional.empty();
        } catch (Exception e) {
            log.warn("Failed to get current user auditor: {}", e.getMessage());
            return Optional.empty();
        }
    }
}
