/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.common.config.properties;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.util.ArrayList;
import java.util.List;

/**
 * 验证码属性
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
@Data
@Configuration
@ConfigurationProperties(prefix = "captcha")
public class CaptchaProperties {
    /**
     * 图片列表
     */
    private List<String> image = new ArrayList<>();

    /**
     * 短信列表
     */
    private List<String> sms = new ArrayList<>();

    /**
     * 邮件列表
     */
    private List<String> email = new ArrayList<>();
}
