/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.common.config.properties;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * 租户配置属性
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
@Data
@Component
@ConfigurationProperties(prefix = "hiver.tenant")
public class TenantProperties {
    /**
     * 是否启用多租户功能
     */
    private boolean enabled = true;

    /**
     * 默认租户ID（当无法解析租户时使用）
     */
    private Long defaultTenantId = 0L;

    /**
     * 系统租户ID（用于系统级操作）
     */
    private Long systemTenantId = -1L;

    /**
     * 需要忽略租户过滤的表名列表
     */
    private List<String> ignoreTables = new ArrayList<>();

    /**
     * 租户ID字段名（数据库字段名）
     */
    private String columnName = "tenant_id";
}
