/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.common.config.tenant;

import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import plus.hiver.common.config.properties.TenantProperties;

/**
 * 租户自动配置类 - 根据配置决定是否启用租户功能
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
@Configuration
public class TenantConfig {
    /**
     * 租户标识解析器 - 仅在租户功能启用时注册
     */
    @Bean
    @ConditionalOnProperty(name = "hiver.tenant.enabled", havingValue = "true")
    public TenantIdentifierResolver tenantIdentifierResolver(TenantProperties tenantProperties) {
        return new TenantIdentifierResolver(tenantProperties);
    }

    /**
     * 租户处理器 - 仅在租户功能启用时注册
     * 用于处理租户相关的业务逻辑
     */
    @Bean
    @ConditionalOnProperty(name = "hiver.tenant.enabled", havingValue = "true")
    public TenantHandler tenantHandler(TenantProperties tenantProperties) {
        return new TenantHandler(tenantProperties);
    }
}
