/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.common.config.tenant;

import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;
import plus.hiver.common.utils.BaseContext;

/**
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
public class TenantRoutingDataSource extends AbstractRoutingDataSource {
    @Override
    protected Object determineCurrentLookupKey() {
        // 返回当前租户的标识，用于查找对应的具体数据源
        return BaseContext.getTenantId();
    }
}
