/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.common.constant;

import cn.hutool.core.util.IdUtil;

/**
 * 安全常量
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
public interface SecurityConstant {
    /**
     * 租户令牌
     */
    String TENANT_TOKEN = "HIVER_TENANT_TOKEN:";

    /**
     * token分割
     */
    String TOKEN_SPLIT = "Bearer ";

    /**
     * JWT签名加密key
     */
    String JWT_SIGN_KEY = IdUtil.simpleUUID();

    /**
     * token参数头
     */
    String HEADER = "accessToken";

    /**
     * appToken参数头
     */
    String APP_HEADER = "appToken";

    /**
     * 在线用户记录
     */
    String ONLINE_USER_PRE = "ONLINE_USER:";

    /**
     * JWT在线用户token退出列表key
     */
    String ONLINE_USER_JWT_LOGOUT_SET_KEY = "ONLINE_USER_JWT_LOGOUT_SET_KEY";

    /**
     * 交互token前缀key
     */
    String TOKEN_PRE = "HIVER_TOKEN_PRE:";

    /**
     * 用户token前缀key 单点登录使用
     */
    String USER_TOKEN = "HIVER_USER_TOKEN:";

    /**
     * 会员交互token前缀key
     */
    String TOKEN_MEMBER_PRE = "HIVER_TOKEN_MEMBER_PRE:";

    /**
     * 会员token前缀key
     */
    String MEMBER_TOKEN = "HIVER_MEMBER_TOKEN:";

    /**
     * 微信保存state前缀key
     */
    String WECHAT_STATE = "HIVER_WECHAT:";
}
