/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.common.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.TenantId;
import plus.hiver.common.base.HiverBaseEntity;
import plus.hiver.common.constant.HiverConstant;
import plus.hiver.common.vo.UserVo;

import java.math.BigDecimal;
import java.util.List;

/**
 * 部门实体类
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
@Data
@Entity
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Table(name = "t_department")
@TableName("t_department")
@Tag(name = "部门")
public class Department extends HiverBaseEntity {
    private static final long serialVersionUID = 1L;

    @TenantId
    @Schema(description = "租户ID")
    @TableField(fill = FieldFill.INSERT)
    private Long tenantId;

    @Schema(description = "部门名称")
    private String title;

    @Schema(description = "父id")
    @Column(nullable = false)
    private Long parentId;

    @Schema(description = "是否为父节点(含子节点) 默认false")
    private Boolean isParent = false;

    @Schema(description = "排序值")
    @Column(precision = 10, scale = 2)
    private BigDecimal sortOrder;

    @Schema(description = "是否启用 0启用 -1禁用")
    private Integer status = HiverConstant.STATUS_NORMAL;

    @Transient
    @TableField(exist = false)
    @Schema(description = "父节点名称")
    private String parentTitle;

    @Transient
    @TableField(exist = false)
    @Schema(description = "主负责人")
    private List<Long> mainHeader;

    @Transient
    @TableField(exist = false)
    @Schema(description = "副负责人")
    private List<Long> viceHeader;

    @Transient
    @TableField(exist = false)
    @Schema(description = "主负责人")
    private List<UserVo> mainHeaders;

    @Transient
    @TableField(exist = false)
    @Schema(description = "副负责人")
    private List<UserVo> viceHeaders;
}
