/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.common.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import plus.hiver.common.base.HiverBaseEntity;

/**
 * 租户表
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
@Data
@Entity
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Table(name = "t_tenant")
@TableName("t_tenant")
@Tag(name = "租户")
public class Tenant extends HiverBaseEntity {
    private static final long serialVersionUID = 1L;

    @Schema(description = "租户名称")
    private String name;

    @Schema(description = "域名地址")
    private String domain;

    @Schema(description = "联系人")
    private String username;

    @Schema(description = "联系人手机号")
    private String mobile;

    @Schema(description = "省市县地址")
    private String address;

    @Schema(description = "街道地址")
    private String street;

    @Schema(description = "租户状态 0启用 -1禁用")
    private Integer status;
}
