/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.common.exception;

import lombok.Getter;
import lombok.ToString;
import lombok.extern.slf4j.Slf4j;
import org.springframework.security.core.AuthenticationException;

/**
 * 处理与认证相关的异常
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
@Getter
@ToString
@Slf4j
public class CustomAuthenticationException extends AuthenticationException {
    String message;

    public CustomAuthenticationException(String message) {
        super(message);
        this.message = message;
    }
}
