/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.common.service;

import plus.hiver.common.base.HiverBaseService;
import plus.hiver.common.entity.DepartmentHeader;
import plus.hiver.common.vo.UserVo;

import java.util.List;

/**
 * 部门负责人接口
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
public interface DepartmentHeaderService extends HiverBaseService<DepartmentHeader, Long> {
    /**
     * 通过部门和负责人类型获取
     */
    List<UserVo> findHeaderByDepartmentId(Long departmentId, Integer type);

    /**
     * 通过部门获取
     */
    List<DepartmentHeader> findByDepartmentIdIn(List<Long> departmentIds);

    /**
     * 通过部门id删除
     */
    void deleteByDepartmentId(Long departmentId);

    /**
     * 通过userId删除
     */
    void deleteByUserId(Long userId);

    /**
     * 是否为部门负责人
     */
    Boolean isDepartmentHeader(Long userId, Long departmentId);

    /**
     * 通过部门和负责人类型获取
     */
    List<UserVo> findHeaderByDepartmentId(Long departmentId);
}
