/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.common.service;

import plus.hiver.common.base.HiverBaseService;
import plus.hiver.common.entity.Permission;

import java.util.List;

/**
 * 权限接口
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
public interface PermissionService extends HiverBaseService<Permission, Long> {
    /**
     * 通过parendId查找
     */
    List<Permission> findByParentIdOrderBySortOrder(Long parentId);

    /**
     * 通过类型和状态获取
     */
    List<Permission> findByTypeAndStatusOrderBySortOrder(Integer type, Integer status);

    /**
     * 通过名称获取
     */
    List<Permission> findByTitle(String title);

    /**
     * 模糊搜索
     */
    List<Permission> findByTitleLikeOrderBySortOrder(String title);
}
