/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.common.service;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import plus.hiver.common.base.HiverBaseService;
import plus.hiver.common.entity.StopWord;
import plus.hiver.common.vo.SearchVo;

/**
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
public interface StopWordService extends HiverBaseService<StopWord, Long> {
    /**
     * 多条件分页获取
     */
    Page<StopWord> findByCondition(StopWord stopWord, SearchVo searchVo, Pageable pageable);
}
