/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.common.serviceimpl;

import jakarta.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import plus.hiver.common.base.HiverBaseServiceImpl;
import plus.hiver.common.dao.DepartmentHeaderDao;
import plus.hiver.common.dao.UserDao;
import plus.hiver.common.entity.DepartmentHeader;
import plus.hiver.common.entity.User;
import plus.hiver.common.service.DepartmentHeaderService;
import plus.hiver.common.vo.UserVo;

import java.util.ArrayList;
import java.util.List;

/**
 * 部门负责人接口实现
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
@Slf4j
@Service
@Transactional
public class DepartmentHeaderServiceImpl extends HiverBaseServiceImpl<DepartmentHeader, Long, DepartmentHeaderDao> implements DepartmentHeaderService {
    @Resource
    private UserDao userDao;

    public DepartmentHeaderServiceImpl(DepartmentHeaderDao dao) {
        super(dao);
    }

    @Override
    public List<UserVo> findHeaderByDepartmentId(Long departmentId, Integer type) {
        List<UserVo> list = new ArrayList<>();
        List<DepartmentHeader> headers = dao.findByDepartmentIdAndType(departmentId, type);
        headers.forEach(e -> {
            User u = userDao.getOne(e.getUserId());
            if (u != null) {
                list.add(new UserVo().setId(u.getId()).setUsername(u.getUsername()).setNickname(u.getNickname()));
            }
        });
        return list;
    }

    @Override
    public List<DepartmentHeader> findByDepartmentIdIn(List<Long> departmentIds) {
        return dao.findByDepartmentIdIn(departmentIds);
    }

    @Override
    public void deleteByDepartmentId(Long departmentId) {
        dao.deleteByDepartmentId(departmentId);
    }

    @Override
    public void deleteByUserId(Long userId) {
        dao.deleteByUserId(userId);
    }

    @Override
    public Boolean isDepartmentHeader(Long userId, Long departmentId) {
        List<DepartmentHeader> headers = dao.findByUserIdAndDepartmentId(userId, departmentId);
        if (headers != null && !headers.isEmpty()) {
            return true;
        }
        return false;
    }

    @Override
    public List<UserVo> findHeaderByDepartmentId(Long departmentId) {
        List<UserVo> list = new ArrayList<>();
        List<DepartmentHeader> headers = dao.findByDepartmentId(departmentId);
        headers.forEach(e -> {
            User u = userDao.getOne(e.getUserId());
            if (u != null) {
                list.add(new UserVo().setId(u.getId()).setUsername(u.getUsername()).setNickname(u.getNickname()));
            }
        });
        return list;
    }
}
