/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.common.sms;

import cn.hutool.core.util.StrUtil;
import jakarta.annotation.Resource;
import org.springframework.stereotype.Component;
import plus.hiver.common.constant.SettingConstant;
import plus.hiver.common.entity.Setting;
import plus.hiver.common.exception.HiverException;
import plus.hiver.common.service.SettingService;

/**
 * 工厂模式
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
@Component
public class SmsFactory {
    @Resource
    private SettingService settingService;

    @Resource
    private AliSms aliSms;

    public Sms getSms() {
        Setting setting = settingService.findByKey(SettingConstant.SMS_USED);
        if (setting == null || StrUtil.isBlank(setting.getValue())) {
            throw new HiverException("您还未配置OSS存储服务");
        }
        String type = setting.getValue();
        if (type.equals(SettingConstant.ALI_SMS)) {
            return aliSms;
        } else {
            throw new HiverException("暂不支持该存储配置，请检查配置");
        }
    }
}
