/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.common.utils;

import plus.hiver.common.entity.User;

/**
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
public class BaseContext {
    private static final ThreadLocal<Long> userId = new ThreadLocal<>();
    private static final ThreadLocal<Long> tenantId = new ThreadLocal<>();
    private static final ThreadLocal<String> username = new ThreadLocal<>();
    private static final ThreadLocal<User> user = new ThreadLocal<>();

    public static Long getUserId() {
        return userId.get();
    }

    public static void setUserId(Long _userId) {
        userId.set(_userId);
    }

    public static Long getTenantId() {
        return tenantId.get();
    }

    public static void setTenantId(Long _tenantId) {
        tenantId.set(_tenantId);
    }

    public static String getUsername() {
        return username.get();
    }

    public static void setUsername(String _username) {
        username.set(_username);
    }

    public static User getUser() {
        return user.get();
    }

    public static void setUser(User _user) {
        user.set(_user);
    }

    public static void removeUser() {
        userId.remove();
        tenantId.remove();
        username.remove();
        user.remove();
    }
}
