/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.common.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import jakarta.servlet.http.HttpServletResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.HttpStatus;
import plus.hiver.common.api.Result;

/**
 * HTTP响应工具类
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
@Slf4j
public class ResponseUtil {
    /**
     * 使用response输出JSON
     *
     * @param response
     * @param resultMap
     */
    public static void out(HttpServletResponse response, Result<Object> resultMap) {
        try {
            ObjectMapper mapper = new ObjectMapper();

            // 注册JavaTimeModule模块
            mapper.registerModule(new JavaTimeModule());
            response.setContentType("application/json;charset=UTF-8");
            response.setStatus(HttpStatus.OK.value());
            mapper.writeValue(response.getWriter(), resultMap);
        } catch (Exception e) {
            log.error(e.toString());
        }
    }

    public static Object resultMap(boolean flag, Integer code, String msg) {
        return resultMap(flag, code, msg, null);
    }

    public static Object resultMap(boolean flag, Integer code, String msg, Object data) {
        if (flag)
            return ResultUtil.data(data, msg);
        else
            return ResultUtil.error(code, msg);
    }
}
