/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.common.utils;

import java.security.SecureRandom;
import java.util.Collection;

/**
 * 字符串工具类
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
public class StringUtil extends org.apache.commons.lang3.StringUtils {
    /**
     * 随机字符
     */
    public static final String STRING = "ABCDEFGHJKMNOPQRSTUVWXYZabcdefghjkmnopqrstuvwxyz1234567890";

    /**
     * 随机数字
     */
    public static final String DIGIT = "1234567890";

    /**
     * 空字符串
     */
    private static final String NULLSTR = "";

    /**
     * 下划线
     */
    private static final char SEPARATOR = '_';

    /**
     * 星号
     */
    private static final char ASTERISK = '*';

    /**
     * 斜杠
     */
    public static final String SLASH = "/";

    /**
     * 得到随机字符
     *
     * @param n
     * @return
     */
    public static String randomStr(int n) {
        String str = "";
        SecureRandom random = new SecureRandom();
        int len = STRING.length() - 1;
        double r;
        for (int i = 0; i < n; i++) {
            r = random.nextDouble() * len;
            str = str + STRING.charAt((int) r);
        }
        return str;
    }

    /**
     * 得到随机数字
     *
     * @param n
     * @return
     */
    public static String randomDigit(int n) {
        String str = "";
        SecureRandom random = new SecureRandom();
        int len = DIGIT.length() - 1;
        double r;
        for (int i = 0; i < n; i++) {
            r = random.nextDouble() * len;
            str = str + DIGIT.charAt((int) r);
        }
        return str;
    }

    /**
     * 判断一个对象是否为空
     *
     * @param object Object
     * @return true：为空 false：非空
     */
    public static boolean isNull(Object object) {
        return object == null;
    }

    /**
     * 判断一个字符串是否为非空串
     *
     * @param str String
     * @return true：非空串 false：空串
     */
    public static boolean isNotEmpty(String str) {
        return !isEmpty(str);
    }

    /**
     * 判断一个字符串是否为空串
     *
     * @param str String
     * @return true：为空 false：非空
     */
    public static boolean isEmpty(String str) {
        return isNull(str) || NULLSTR.equals(str.trim());
    }

    /**
     * 判断一个Collection是否为空， 包含List，Set，Queue
     *
     * @param coll 要判断的Collection
     * @return true：为空 false：非空
     */
    public static boolean isEmpty(Collection<?> coll) {
        return isNull(coll) || coll.isEmpty();
    }
}
