/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.ai.controller;

import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.messages.UserMessage;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.ai.openai.OpenAiChatModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import plus.hiver.common.annotation.PermissionTag;
import reactor.core.publisher.Flux;

@RestController
@Tag(name="AI\u6a21\u5757")
@PermissionTag(permission="ai:*")
@RequestMapping(value={"/hiver/ai"})
public class DeepSeekController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeepSeekController.class);
    private final OpenAiChatModel chatModel;

    @Autowired
    public DeepSeekController(OpenAiChatModel openAiChatModel) {
        this.chatModel = openAiChatModel;
    }

    @GetMapping(value={"/chat"})
    public Map chat(@RequestParam(value="message") String string) {
        return Map.of("generation", this.chatModel.call(string));
    }

    @GetMapping(value={"/chatFlux"}, produces={"text/event-stream; charset=UTF-8"})
    public Flux<ChatResponse> chatFlux(@RequestParam(value="message") String string) {
        Prompt prompt = new Prompt((Message)new UserMessage(string));
        return this.chatModel.stream(prompt);
    }
}

