/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.module.iot.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import plus.hiver.common.annotation.PermissionTag;
import plus.hiver.common.api.Result;
import plus.hiver.common.utils.ResultUtil;
import plus.hiver.module.iot.mqtt.gateway.MqttGateway;

/**
 * MQTT测试接口
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
@Slf4j
@RestController
@Tag(name = "Iot Mqtt模块")
@PermissionTag(permission = "mqtt:*" )
@RequestMapping("/hiver/mqtt")
public class MqttController {
    @Autowired
    private MqttGateway mqttGateway;

    @PostMapping("/sendToDefaultTopic")
    @Operation(summary = "向默认主题发送消息")
    public Result sendToDefaultTopic(String payload) {
        mqttGateway.sendToMqtt(payload);
        return ResultUtil.success(null);
    }

    @PostMapping("/sendToTopic")
    @Operation(summary = "向指定主题发送消息")
    public Result sendToTopic(String payload, String topic) {
        mqttGateway.sendToMqtt(payload, topic);
        return ResultUtil.success(null);
    }
}
