/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.module.iot.mqtt.config;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.core.MessageProducer;
import org.springframework.integration.mqtt.inbound.MqttPahoMessageDrivenChannelAdapter;
import org.springframework.integration.mqtt.support.DefaultPahoMessageConverter;
import org.springframework.integration.mqtt.support.MqttMessageConverter;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessagingException;
import plus.hiver.module.iot.mqtt.config.MqttConfig;

@Configuration
public class MqttInboundConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MqttInboundConfig.class);
    @Autowired
    private MqttConfig mqttConfig;

    @Bean
    public MessageChannel mqttInputChannel() {
        return new DirectChannel();
    }

    @Bean
    public MessageProducer inbound() {
        MqttPahoMessageDrivenChannelAdapter mqttPahoMessageDrivenChannelAdapter = new MqttPahoMessageDrivenChannelAdapter(this.mqttConfig.getUrl(), "subscriberClient", new String[]{this.mqttConfig.getDefaultTopic()});
        mqttPahoMessageDrivenChannelAdapter.setCompletionTimeout(5000L);
        mqttPahoMessageDrivenChannelAdapter.setConverter((MqttMessageConverter)new DefaultPahoMessageConverter());
        mqttPahoMessageDrivenChannelAdapter.setQos(new int[]{1});
        mqttPahoMessageDrivenChannelAdapter.setOutputChannel(this.mqttInputChannel());
        return mqttPahoMessageDrivenChannelAdapter;
    }

    @Bean
    @ServiceActivator(inputChannel="mqttInputChannel")
    public MessageHandler handler() {
        return new MessageHandler(){

            public void handleMessage(Message<?> message) throws MessagingException {
                log.info("handleMessage : {}", message.getPayload());
            }
        };
    }
}

