/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.module.iot.mqtt.config;

import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.mqtt.core.DefaultMqttPahoClientFactory;
import org.springframework.integration.mqtt.core.MqttPahoClientFactory;
import org.springframework.integration.mqtt.outbound.MqttPahoMessageHandler;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import plus.hiver.module.iot.mqtt.config.MqttConfig;

@Configuration
public class MqttOutboundConfig {
    @Autowired
    private MqttConfig mqttConfig;

    @Bean
    public MqttPahoClientFactory mqttClientFactory() {
        DefaultMqttPahoClientFactory defaultMqttPahoClientFactory = new DefaultMqttPahoClientFactory();
        MqttConnectOptions mqttConnectOptions = new MqttConnectOptions();
        mqttConnectOptions.setServerURIs(new String[]{this.mqttConfig.getUrl()});
        mqttConnectOptions.setUserName(this.mqttConfig.getUsername());
        mqttConnectOptions.setPassword(this.mqttConfig.getPassword().toCharArray());
        defaultMqttPahoClientFactory.setConnectionOptions(mqttConnectOptions);
        return defaultMqttPahoClientFactory;
    }

    @Bean
    @ServiceActivator(inputChannel="mqttOutboundChannel")
    public MessageHandler mqttOutbound() {
        MqttPahoMessageHandler mqttPahoMessageHandler = new MqttPahoMessageHandler("publisherClient", this.mqttClientFactory());
        mqttPahoMessageHandler.setAsync(true);
        mqttPahoMessageHandler.setDefaultTopic(this.mqttConfig.getDefaultTopic());
        return mqttPahoMessageHandler;
    }

    @Bean
    public MessageChannel mqttOutboundChannel() {
        return new DirectChannel();
    }
}

