/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.module.open.controller;

import cn.hutool.core.util.IdUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import plus.hiver.common.annotation.PermissionTag;
import plus.hiver.common.api.Result;
import plus.hiver.common.base.HiverBaseController;
import plus.hiver.common.base.HiverBaseService;
import plus.hiver.common.utils.PageUtil;
import plus.hiver.common.utils.ResultUtil;
import plus.hiver.common.vo.PageVo;
import plus.hiver.common.vo.SearchVo;
import plus.hiver.module.open.entity.Client;
import plus.hiver.module.open.service.ClientService;

@RestController
@Tag(name="\u5ba2\u6237\u7aef\u7ba1\u7406\u63a5\u53e3")
@PermissionTag(permission="client:*")
@RequestMapping(value={"/hiver/client"})
@Transactional
public class ClientController
extends HiverBaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClientController.class);
    @Resource
    private ClientService clientService;

    public HiverBaseService getService() {
        return this.clientService;
    }

    @GetMapping(value={"/getByCondition"})
    @Operation(summary="\u591a\u6761\u4ef6\u5206\u9875\u83b7\u53d6")
    public Result<Page<Client>> getByCondition(Client client, SearchVo searchVo, PageVo pageVo) {
        Page<Client> page = this.clientService.findByCondition(client, searchVo, PageUtil.initPage((PageVo)pageVo));
        return new ResultUtil().setData(page);
    }

    @GetMapping(value={"/getSecretKey"})
    @Operation(summary="\u751f\u6210\u968f\u673asecretKey")
    public Result<String> getSecretKey() {
        String string = IdUtil.simpleUUID();
        return new ResultUtil().setData((Object)string);
    }

    @Generated
    public ClientController(ClientService clientService) {
        this.clientService = clientService;
    }
}

